/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import org.autoplot.AppManager;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.JythonUtil;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.dom.ApplicationController;
import org.autoplot.jythonsupport.ui.EditorAnnotationsSupport;
import org.autoplot.jythonsupport.ui.EditorContextMenu;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.scriptconsole.AppScriptPanelSupport;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.das2.jythoncompletion.JythonInterpreterProvider;
import org.das2.jythoncompletion.ui.CompletionImpl;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class JythonScriptPanel
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot");
    ApplicationModel model;
    AutoplotUI app;
    ApplicationController applicationController;
    DataSetSelector selector;
    AppScriptPanelSupport support;
    static final int CONTEXT_DATA_SOURCE = 1;
    static final int CONTEXT_APPLICATION = 0;
    private int context = 0;
    File runningScript = null;
    EditorContextMenu menu;
    boolean containsTabs = false;
    private transient DocumentListener dirtyListener;
    private static final String ACTIONKEY_SAVE = "save";
    private static final String ACTIONKEY_EXECUTE = "execute";
    private JLabel caretPositionLabel;
    private JComboBox contextSelector;
    private JButton executeButton;
    private JTextField fileNameTextField;
    private JButton interruptButton;
    private JScrollPane jScrollPane2;
    private JButton newScriptButton;
    private JButton openButton;
    private JButton saveAsButton;
    private EditorTextPane textArea;
    Pattern jythonRefPattern = Pattern.compile("\\s*((\\S+\\.jy(ds)?|\\<string\\>)\\:(\\d+))");
    protected String filename = null;
    public static final String PROP_FILENAME = "filename";
    protected boolean dirty = false;
    public static final String PROP_DIRTY = "dirty";

    public void loadExampleUri(String uri) {
        try {
            File ff = DataSetURI.getFile((String)uri, (ProgressMonitor)new NullProgressMonitor());
            this.loadFile(ff);
        }
        catch (IOException ex) {
            Logger.getLogger(JythonScriptPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public JythonScriptPanel(AutoplotUI app, DataSetSelector selector) {
        this.initComponents();
        this.setMinimumSize(new Dimension(400, 400));
        this.jScrollPane2.getVerticalScrollBar().setUnitIncrement(12);
        this.setContext(0);
        this.model = app.getApplicationModel();
        this.app = app;
        this.support = new AppScriptPanelSupport(this, this.model, selector);
        this.applicationController = this.model.getDocumentModel().getController();
        this.selector = selector;
        this.textArea.setFont(Font.decode(JythonCompletionProvider.getInstance().settings().getEditorFont()));
        this.textArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int pos = JythonScriptPanel.this.textArea.getCaretPosition();
                Element root = JythonScriptPanel.this.textArea.getDocument().getDefaultRootElement();
                int irow = root.getElementIndex(pos);
                int icol = pos - root.getElement(irow).getStartOffset();
                String text = "" + (1 + irow) + "," + (1 + icol);
                int isel = JythonScriptPanel.this.textArea.getSelectionEnd() - JythonScriptPanel.this.textArea.getSelectionStart();
                int iselRow0 = root.getElementIndex(JythonScriptPanel.this.textArea.getSelectionStart());
                int iselRow1 = root.getElementIndex(JythonScriptPanel.this.textArea.getSelectionEnd());
                if (isel > 0) {
                    text = iselRow1 > iselRow0 ? "[" + isel + "ch," + (1 + iselRow1 - iselRow0) + "lines]" : "[" + isel + "ch]";
                }
                JythonScriptPanel.this.caretPositionLabel.setText(text);
            }
        });
        this.dirtyListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JythonScriptPanel.this.setDirty(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JythonScriptPanel.this.setDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.textArea.getDocument().addDocumentListener(this.dirtyListener);
        this.textArea.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null) {
                    ((Document)evt.getOldValue()).removeDocumentListener(JythonScriptPanel.this.dirtyListener);
                }
                ((Document)evt.getNewValue()).addDocumentListener(JythonScriptPanel.this.dirtyListener);
            }
        });
        this.textArea.getActionMap().put(ACTIONKEY_SAVE, new AbstractAction(ACTIONKEY_SAVE){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                try {
                    JythonScriptPanel.this.support.save();
                }
                catch (FileNotFoundException ex) {
                    JythonScriptPanel.this.model.getExceptionHandler().handle((Throwable)ex);
                }
                catch (IOException ex) {
                    JythonScriptPanel.this.model.getExceptionHandler().handle((Throwable)ex);
                }
            }
        });
        this.textArea.getActionMap().put(ACTIONKEY_EXECUTE, new AbstractAction(ACTIONKEY_EXECUTE){

            @Override
            public void actionPerformed(ActionEvent e) {
                JythonScriptPanel.this.executeButtonActionPerformed(e);
            }
        });
        AppManager.getInstance().addCloseCallback(app, "jythonScriptPanel", new AppManager.CloseCallback(){

            @Override
            public boolean checkClose() {
                if (JythonScriptPanel.this.isDirty() && JythonScriptPanel.this.isVisible() && JythonScriptPanel.this.textArea.getDocument().getLength() > 0) {
                    int resp = JOptionPane.showConfirmDialog(JythonScriptPanel.this, "Script Editor contains unsaved changes.  Save these changes?");
                    switch (resp) {
                        case 2: {
                            return false;
                        }
                        case 0: {
                            try {
                                return JythonScriptPanel.this.support.save() == 0;
                            }
                            catch (IOException ex) {
                                return false;
                            }
                        }
                        case 1: {
                            return true;
                        }
                    }
                    return false;
                }
                return true;
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), ACTIONKEY_SAVE);
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(117, 0), ACTIONKEY_EXECUTE);
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(117, 64), ACTIONKEY_EXECUTE);
        EditorContextMenu menu = new EditorContextMenu(this.textArea);
        menu.addExampleAction((Action)new AbstractAction("makePngWalk.jy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                JythonScriptPanel.this.loadExample("/scripts/pngwalk/makePngWalk.jy");
            }
        });
        menu.addExampleAction((Action)new AbstractAction("addDigitizer.jy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                JythonScriptPanel.this.loadExample("/scripts/addDigitizer.jy");
            }
        });
        menu.addExampleAction((Action)new AbstractAction("splineDemo.jy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                JythonScriptPanel.this.loadExample("/scripts/splineDemo.jy");
            }
        });
        menu.addExampleAction((Action)new AbstractAction("More Jython Scripts..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                DataSourceUtil.openBrowser((String)"https://github.com/autoplot/dev/");
            }
        });
        menu.addExampleAction((Action)new AbstractAction("mashup.jyds"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                JythonScriptPanel.this.loadExample("/mashup.jyds");
            }
        });
        menu.addExampleAction((Action)new AbstractAction("rheology.jyds"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                JythonScriptPanel.this.loadExample("/rheology.jyds");
            }
        });
        menu.addExampleAction((Action)new AbstractAction("More Jython Data Source Scripts..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                DataSourceUtil.openBrowser((String)"https://ci-pw.physics.uiowa.edu/job/autoplot-release/ws/autoplot/JythonDataSource/src/");
            }
        });
        JMenuItem mi = new JMenuItem(new AbstractAction("Run Git Diff"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                try {
                    if (JythonScriptPanel.this.filename != null) {
                        File f = new File(JythonScriptPanel.this.filename);
                        JythonScriptPanel.this.support.save();
                        AppScriptPanelSupport.markChanges(JythonScriptPanel.this.getEditorPanel().getEditorAnnotationsSupport(), f);
                    } else {
                        JOptionPane.showMessageDialog(JythonScriptPanel.this, "Script must be from a file in a local git repository");
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(JythonScriptPanel.this, ex);
                }
            }
        });
        menu.addMenuItem(mi);
        menu.setDataSetSelector(selector);
        this.menu = menu;
        JythonCompletionProvider.getInstance().addPropertyChangeListener("message", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JythonScriptPanel.this.applicationController.setStatus(JythonCompletionProvider.getInstance().getMessage());
            }
        });
        this.support.addPropertyChangeListener("interruptable", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    JythonScriptPanel.this.interruptButton.setEnabled(false);
                    JythonScriptPanel.this.executeButton.setEnabled(true);
                } else {
                    JythonScriptPanel.this.interruptButton.setEnabled(true);
                    JythonScriptPanel.this.executeButton.setEnabled(false);
                }
            }
        });
        CompletionImpl impl = CompletionImpl.get();
        impl.startPopup((JTextComponent)this.textArea);
    }

    private void loadExample(String resourceFile) {
        try {
            URL url = EditorContextMenu.class.getResource(resourceFile);
            if (this.isDirty() && this.support.saveAs() == 1) {
                return;
            }
            this.support.loadInputStream(url.openStream());
            if (resourceFile.endsWith(".jy")) {
                this.setContext(0);
            } else {
                this.setContext(1);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    protected void updateStatus() {
        if (this.filename == null) {
            this.fileNameTextField.setText("" + (this.dirty ? " *" : "") + (this.containsTabs ? " TAB" : ""));
            this.getEditorPanel().setEditable(true);
        } else {
            boolean writable;
            File lfile = new File(this.filename);
            try {
                writable = lfile.canWrite() && !FileUtil.isParent((File)FileSystem.settings().getLocalCacheDir(), (File)lfile);
            }
            catch (SecurityException ex) {
                writable = false;
            }
            this.getEditorPanel().setEditable(writable);
            this.fileNameTextField.setText(this.filename + (writable ? "" : " (read only)") + (this.dirty ? " *" : "") + (this.containsTabs ? " TAB" : ""));
        }
    }

    int getContext() {
        return this.context;
    }

    protected final void setContext(int context) {
        this.context = context;
        this.contextSelector.setSelectedIndex(context);
        if (context == 0) {
            this.textArea.putClientProperty((Object)"JYTHON_INTERPRETER_PROVIDER", (Object)new JythonInterpreterProvider(){

                public PythonInterpreter createInterpreter() throws IOException {
                    InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, JythonScriptPanel.this.model.getDom(), null);
                    interp.set("params", (PyObject)new PyDictionary());
                    interp.set("resourceURI", Py.None);
                    return interp;
                }
            });
        } else if (context == 1) {
            this.textArea.putClientProperty((Object)"JYTHON_INTERPRETER_PROVIDER", (Object)new JythonInterpreterProvider(){

                public PythonInterpreter createInterpreter() throws IOException {
                    InteractiveInterpreter interp = JythonUtil.createInterpreter(false, false);
                    interp.set("params", (PyObject)new PyDictionary());
                    interp.set("resourceURI", Py.None);
                    return interp;
                }
            });
        }
    }

    private void initComponents() {
        this.executeButton = new JButton();
        this.saveAsButton = new JButton();
        this.openButton = new JButton();
        this.contextSelector = new JComboBox();
        this.caretPositionLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.textArea = new EditorTextPane();
        this.newScriptButton = new JButton();
        this.interruptButton = new JButton();
        this.fileNameTextField = new JTextField();
        this.executeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/go.png")));
        this.executeButton.setText("Run");
        this.executeButton.setToolTipText("<html>Run the script.  <br>Alt enters editor GUI.  <br>Ctrl attempts to trace program location.  <br>Shift enters editor GUI.");
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.executeButtonActionPerformed(evt);
            }
        });
        this.saveAsButton.setFont(this.saveAsButton.getFont());
        this.saveAsButton.setText("Save As...");
        this.saveAsButton.setToolTipText("Save the buffer to a local file.");
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.saveAsButtonActionPerformed(evt);
            }
        });
        this.openButton.setText("Open...");
        this.openButton.setToolTipText("Open the local file to the buffer.");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.openButtonActionPerformed(evt);
            }
        });
        this.contextSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Application Context", "Data Source Context"}));
        this.contextSelector.setToolTipText("<html>select the context for the script: to create new datasets (data source context), or to control an application (application context)</html>\n");
        this.contextSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.contextSelectorActionPerformed(evt);
            }
        });
        this.caretPositionLabel.setText("1,1");
        this.caretPositionLabel.setToolTipText("row,column; or the number of characters and lines selected.");
        this.textArea.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                JythonScriptPanel.this.textAreaFocusGained(evt);
            }
        });
        this.jScrollPane2.setViewportView((Component)this.textArea);
        this.newScriptButton.setText("New");
        this.newScriptButton.setToolTipText("Reset the buffer to a new file.");
        this.newScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.newScriptButtonActionPerformed(evt);
            }
        });
        this.interruptButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/stop.png")));
        this.interruptButton.setText("Stop");
        this.interruptButton.setToolTipText("Interrupt running script");
        this.interruptButton.setEnabled(false);
        this.interruptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.interruptButtonActionPerformed(evt);
            }
        });
        this.fileNameTextField.setEditable(false);
        this.fileNameTextField.setFont(this.fileNameTextField.getFont().deriveFont((float)this.fileNameTextField.getFont().getSize() - 2.0f));
        this.fileNameTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.executeButton, -2, 121, -2).addPreferredGap(0).add((Component)this.interruptButton).add(18, 18, 18).add((Component)this.saveAsButton).addPreferredGap(0).add((Component)this.openButton).addPreferredGap(0).add((Component)this.newScriptButton).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.contextSelector, -2, -1, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.fileNameTextField).addPreferredGap(0).add((Component)this.caretPositionLabel, -2, 99, -2)).add((Component)this.jScrollPane2, -2, 0, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.executeButton).add((Component)this.contextSelector, -2, -1, -2).add((Component)this.saveAsButton).add((Component)this.openButton).add((Component)this.newScriptButton).add((Component)this.interruptButton)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 279, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.caretPositionLabel).add((Component)this.fileNameTextField, -2, -1, -2))));
        layout.linkSize(new Component[]{this.executeButton, this.interruptButton, this.newScriptButton, this.openButton, this.saveAsButton}, 2);
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        if (this.dirty && this.support.file != null) {
            try {
                this.support.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.err.println("== Executing Script ==");
        if (this.context == 0) {
            this.model.getDom().getController().getScriptContext().setWindow(this.model);
        }
        if (this.support.file != null) {
            this.setRunningScript(this.support.file);
        }
        this.support.executeScript(evt.getModifiers());
    }

    private void saveAsButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.support.saveAs();
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.support.open();
    }

    private void contextSelectorActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.setContext(this.contextSelector.getSelectedIndex());
    }

    private void textAreaFocusGained(FocusEvent evt) {
        CompletionImpl impl = CompletionImpl.get();
        impl.startPopup((JTextComponent)this.textArea);
    }

    private void newScriptButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.support.newScript();
    }

    private void interruptButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.support.interrupt();
    }

    public EditorTextPane getEditorPanel() {
        return this.textArea;
    }

    public ActionListener getConsoleListener() {
        return e -> {
            String printline = e.getActionCommand();
            Matcher jythonMatcher = this.jythonRefPattern.matcher(printline);
            if (jythonMatcher.find()) {
                int iff;
                String jythonRef = jythonMatcher.group(1);
                String currentFilename = this.filename == null ? "<string>" : this.filename;
                String messageSource = jythonMatcher.group(2);
                if (messageSource.contains("/") && currentFilename.endsWith(messageSource.substring(iff = messageSource.lastIndexOf("/")))) {
                    URI uri;
                    int i2 = messageSource.indexOf("(http");
                    if (i2 > 0) {
                        messageSource = messageSource.substring(i2 + 1);
                    }
                    if ((uri = DataSetURI.getResourceURI((String)messageSource)) != null) {
                        File ff = DataSetURI.getCacheFilename((URI)uri);
                        messageSource = ff == null && uri.getScheme().equals("file") ? uri.getPath() : ff.toString();
                    }
                }
                if (currentFilename.endsWith(messageSource)) {
                    int line = Integer.parseInt(jythonMatcher.group(4));
                    try {
                        this.support.annotationsSupport.annotateLine(line, "codeHint", printline);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                jythonRef = null;
            }
        };
    }

    public JScrollPane getScrollPane() {
        return this.jScrollPane2;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        String oldFilename = this.filename;
        this.filename = filename;
        if (!(filename == oldFilename || oldFilename != null && oldFilename.equals(filename) || filename == null)) {
            final File loadFile = new File(filename);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        JythonScriptPanel.this.loadFile(loadFile);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(JythonScriptPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            new Thread(r, "loadScript603").start();
        }
        this.updateStatus();
        this.firePropertyChange(PROP_FILENAME, oldFilename, filename);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        boolean oldDirty = this.dirty;
        this.dirty = dirty;
        if (oldDirty != dirty) {
            this.updateStatus();
        }
        this.firePropertyChange(PROP_DIRTY, oldDirty, dirty);
    }

    public void resetUndo() {
        Document doc = this.textArea.getDocument();
        if (doc instanceof SyntaxDocument) {
            ((SyntaxDocument)this.textArea.getDocument()).resetUndo();
        }
    }

    public boolean loadFile(File file) throws IOException {
        if (this.isDirty()) {
            return false;
        }
        this.support.loadFile(file);
        this.textArea.putClientProperty((Object)"JYTHON_INTERPRETER_PWD", (Object)(file.getParent() + "/"));
        return true;
    }

    public EditorAnnotationsSupport getAnnotationsSupport() {
        return this.support.annotationsSupport;
    }

    public void addSettingsMenuItem(JMenuItem menu) {
        this.menu.addSettingsMenuItem(menu);
    }

    public void addMenuItem(JMenuItem menu) {
        this.menu.addMenuItem(menu);
    }

    public void doRebuildMenu() {
        this.menu.doRebuildMenu();
    }

    public void setRunningScript(File f) {
        this.runningScript = f;
    }

    public File getRunningScript() {
        return this.runningScript;
    }
}

